//
//  ModelTranslateAnimationViewController.m
//  QMapKitDemo
//
//  Created by Keith Cao on 2023/10/24.
//  Copyright © 2023 tencent. All rights reserved.
//

#import "ModelTranslateAnimationViewController.h"
#import <QMapVisualPlugin/QModelOverlayView.h>

@interface ModelTranslateAnimationViewController () <QGLOverlayDelegate>

@property (nonatomic, strong) QModelOverlay *model;

@property (nonatomic, strong) NSMutableArray <NSNumber *> *translatePoints;

@end

@implementation ModelTranslateAnimationViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
	[self createModelOverlay];
	[self setUpRoutePolyline];
}

- (void)createModelOverlay
{
	
	NSString *gltfPath = @"xxx/xxx.gltf";		///gltf后缀文件路径
	NSString *path = [[NSBundle mainBundle] pathForResource:gltfPath ofType:nil];
	
	self.model = [[QModelOverlay alloc] init];
	self.model.path = path;
	self.model.coordinate = CLLocationCoordinate2DMake(39.9442, 116.324);
	
	// 屏幕像素大小，模型大小固定
	{
		QGLOverlayPixelRenderMode *pxMode = [[QGLOverlayPixelRenderMode alloc] init];
		pxMode.size = CGSizeMake(100, 100);
		self.model.renderMode = pxMode;
	}
	
	// 可调整模型的X、Y、Z轴
	self.model.rotationX = 90;
	
	self.model.delegate = self;
	
	[self.mapView addOverlay:self.model];
}

- (NSString *)testTitle
{
	return @"执行动画";
}

- (void)handleTestAction
{
	[self executeTranslateAnimation];
}

- (void)executeTranslateAnimation
{
	[self.model playAnimationWithIndex:0 speed:1 autoRepeat:YES];
	[self.model startTranslateAnimation:self.translatePoints duration:15 initRotation:180 autoRotate:YES];
}

- (void)setUpRoutePolyline
{
	const NSInteger cnt = 6;
	
	CLLocationCoordinate2D polylineCoords[cnt];
	polylineCoords[0].latitude = 39.9442;
	polylineCoords[0].longitude = 116.324;
	
	polylineCoords[1].latitude = 39.9442;
	polylineCoords[1].longitude = 116.444;
	
	polylineCoords[2].latitude = 39.9042;
	polylineCoords[2].longitude = 116.454;
	
	polylineCoords[3].latitude = 39.9042;
	polylineCoords[3].longitude = 116.334;
	
	polylineCoords[4].latitude = 39.8442;
	polylineCoords[4].longitude = 116.334;
	
	polylineCoords[5].latitude = 39.8442;
	polylineCoords[5].longitude = 116.434;
	
	QPolyline *polyline = [QPolyline polylineWithCoordinates:polylineCoords count:cnt];
	
	[self.mapView addOverlay:polyline];
	
	
	[self.mapView setVisibleMapRect:polyline.boundingMapRect edgePadding:UIEdgeInsetsMake(20, 20, 20, 40) animated:YES];
	
	// 创建平移路线点数组
	self.translatePoints = [NSMutableArray array];
	
	for (int i = 0; i < cnt; i ++)
	{
		NSNumber *lat = [NSNumber numberWithFloat:polylineCoords[i].latitude];
		NSNumber *lon = [NSNumber numberWithFloat:polylineCoords[i].longitude];
		
		[self.translatePoints addObject:lat];
		[self.translatePoints addObject:lon];
	}
}

#pragma mark - MapDelegate

- (QOverlayView *)mapView:(QMapView *)mapView viewForOverlay:(id<QOverlay>)overlay
{
	if ([overlay isKindOfClass:[QModelOverlay class]])
	{
		QModelOverlayView *render = [[QModelOverlayView alloc] initWithOverlay:overlay];
		
		return render;
	}
	else if ([overlay isKindOfClass:[QPolyline class]])
	{
		QTexturePolylineView *polylineView = [[QTexturePolylineView alloc] initWithPolyline:overlay];
		polylineView.drawType = QTextureLineDrawType_ColorLine;
		polylineView.strokeColor = [UIColor blueColor];
		polylineView.lineWidth = 20;
		polylineView.borderColor = [UIColor greenColor];
		polylineView.borderWidth = 4;
		
		QPolyline *polyline = (QPolyline *)overlay;
		NSMutableArray<QSegmentColor *> *colors = [NSMutableArray array];
		for (int i = 0; i < polyline.pointCount - 1; i++)
		{
			QSegmentColor *color = [[QSegmentColor alloc] init];
			color.startIndex = i;
			color.endIndex = i + 1;
			
			if (i % 2 == 0)
			{
				color.color = [UIColor greenColor];
			}
			else
			{
				color.color = [UIColor blueColor];
			}
			
			
			[colors addObject:color];
		}
		
		polylineView.segmentColor = colors;
		
		return polylineView;
	}
	
	return nil;
}

#pragma mark -- ModelOverlay Delegate

- (void)glOverlay:(QGLOverlay *)overlay loadStatus:(QGLOverlayLoadStatus)status withProgress:(CGFloat)progress
{
	NSLog(@"%s , Modeloverlay LoadStatus:%lu, progress:%f", __FUNCTION__, status, progress);
}


@end
